```markdown
# Vol 3 Kernel Diagnostics

This repository contains everything needed to reproduce and validate the Reproduction‑Kernel Builder & Diagnostics pipeline from Volume 3 of the Absolute Relativity theory series—and to serve as a solid foundation for the Volume 4–6 work (null‑cone pivots, PDE solvers, RG proofs, and more). All inputs (pivot rule, fractal dimensions) come from the deep‑research‑verified anchor list, including the half‑step null‑cone contexts, and the code builds the tridiagonal kernel matrix, computes spectral radii, and produces summary outputs.

## Contents

- **`vol3_kernel_spec.txt`**  
  Plain‑text specification of the pivot function and tridiagonal construction rules.

- **`D_values.csv`**  
  Two‑column CSV (`n,D`) of verified fractal dimensions from the audit report, **including** \(n=\pm1.5\) for the null‑cone pivot.

- **`run_kernel.py`** or **`kernel_notebook.ipynb`**  
  Python driver script/notebook that:
  1. Parses `vol3_kernel_spec.txt`  
  2. Loads `D_values.csv`  
  3. Builds the \(N\times N\) matrix \(M^{(i)}\) **for each** context \(i\), with  
     \[
       M^{(i)}_{k,k}   = D_i - 2\,g(D_i), 
       \quad 
       M^{(i)}_{k,k\pm1} = g(D_i), 
       \quad 
       g(D_i)=\tfrac{D_i}{3}
     \]
  4. Computes each matrix’s dominant eigenvalue \(\rho_i\)  
  5. Outputs:
     - `kernel_eigs.csv` (`n,D,rho`)
     - `rho_vs_D.png` (scatter plot versus the identity line)
     - `M_heatmap.png` (heatmap of \(M^{(i)}\) at the median context)

- **`kernel_utils/`**  
  Reusable helpers for future volumes:
  - `weights.py` – Gaussian spectral‑weight function \(w_\ell(\delta)\) (Vol 4 form).  
  - `legendre_kernel.py` – builder for 2‑sphere collapse kernels (used in Vol 4 examples).

- **`requirements.txt`**  
```

numpy
scipy
pandas
matplotlib

````

- **`tests/`**  
- `test_D_curve.py` – verifies monotonicity and mirror symmetry of `D_values.csv`.  
- `test_kernel_sanity.py` – checks that \(\rho(D)\) stays within ± 0.03 of \(D\) and that ≥ 95 % of Gaussian weight mass lies in \(\ell\le3\).

- **`reports/`**  
Contains the anchor‑verification DOCX.

- **`data/`**  
Empty folders (`meteors/`, `plasma/`, etc.) with `.gitkeep` for future empirical stubs.

- **`results/`**  
(git‑ignored) Where `kernel_eigs.csv`, `rho_vs_D.png`, and `M_heatmap.png` land.

- **`LICENSE`**  
MIT License (2025 Kent Nimmo).

## Anchor Data Sources

See [ANCHOR_DATA_SOURCES.md](ANCHOR_DATA_SOURCES.md) for the full table of \(n,D\pm\sigma\), measurement systems, methods, and references—now including \(n=\pm1.5\).

## Getting Started

1. **Clone the repo**  
 ```bash
 git clone https://github.com/Kent-Nimmo/vol3-kernel-diagnostics.git
 cd vol3-kernel-diagnostics
````

2. **Install dependencies**

   ```bash
   python3 -m venv venv
   source venv/bin/activate
   pip install -r requirements.txt
   ```

3. **Verify inputs**
   Ensure `D_values.csv` matches the audit‑verified anchor list (including half‑steps).

4. **Run the diagnostics**

   ```bash
   python run_kernel.py
   ```

   *(Or open and run `kernel_notebook.ipynb` in Jupyter.)*

5. **Inspect outputs**
   Look in `results/` for:

   * `kernel_eigs.csv` (`n,D,ρ`)
   * `rho_vs_D.png`
   * `M_heatmap.png`

6. **Run tests**

   ```bash
   pytest -q
   ```

## License

This project is licensed under the MIT License. See the full text in `LICENSE`.

```
```
